#include <bits/stdc++.h>
using namespace std;

const int MAXN = 200000;
const int MXLOG = 18;

vector <int> tgraf[2][MAXN+5];
vector <int> graf[2][MAXN+5];
int sz[2][MAXN+5];
int in[2][MAXN+5];
int out[2][MAXN+5];
int tjm[2];
int par[2][MAXN+5][MXLOG];

bool is_parent(int idx, int a, int b){
    return (a == 0) || (in[idx][a] <= in[idx][b] && out[idx][b] <= out[idx][a]);
}
void dfs_size(int idx, int v, int p){
    par[idx][v][0] = p;
    for(int j=1; j<MXLOG; j++){
        par[idx][v][j] = par[idx][par[idx][v][j-1]][j-1];
    }
    sz[idx][v] = 1;
    for(auto c : tgraf[idx][v]){
        if(c == p) continue;
        graf[idx][v].push_back(c);
        dfs_size(idx, c, v);
        sz[idx][v] += sz[idx][c];
    }
}
int chroot[2][MAXN+5];
void dfs(int idx, int v){
    int mx = 0;
    in[idx][v] = ++tjm[idx];
    for(auto c : graf[idx][v]){
        if(sz[idx][c] > sz[idx][mx]) mx = c;
    }
    if(mx == 0){
        out[idx][v] = tjm[idx];
        return;
    }
    chroot[idx][mx] = chroot[idx][v];
    dfs(idx, mx);
    for(auto c : graf[idx][v]){
        if(c == mx) continue;
        chroot[idx][c] = c;
        dfs(idx, c);
    }
    out[idx][v] = tjm[idx];
}

int lca(int idx, int a, int b){
    if(is_parent(idx, a, b)) return a;
    for(int j=MXLOG-1; j>=0; j--) if(!is_parent(idx, par[idx][a][j], b)) a = par[idx][a][j];
    return par[idx][a][0];
}

int bit[MAXN+5];
void addbit(int x){
    while(x <= MAXN){
        bit[x]++;
        x += x & -x;
    }
}

int getbit(int x){
    int res = 0;
    while(x){
        res += bit[x];
        x -= x & -x;
    }
    return res;
}

bool ime[MAXN+5];

void Resi(int N, int Q, int P, int *U1, int *V1, int *U2, int *V2, int *A1, int *B1, int *C1, int *D1, int *R){
    //drvo dddd;
    for(int i=1; i<N; i++){
        tgraf[0][U1[i]].push_back(V1[i]);
        tgraf[0][V1[i]].push_back(U1[i]);
        tgraf[1][U2[i]].push_back(V2[i]);
        tgraf[1][V2[i]].push_back(U2[i]);
    }
    dfs_size(0, 1, 0);
    dfs_size(1, 1, 0);
    chroot[0][1] = 1;
    chroot[1][2] = 1;
    dfs(0, 1);
    dfs(1, 1);
    if(N > 30000) return;
    int lstr = 0;
    for(int qr=1; qr<=Q; qr++){
        for(int i=1; i<=N; i++) ime[i] = 0;
        int a = (A1[qr] + lstr*P - 1)%N +1;
        int b = (B1[qr] + lstr*P - 1)%N +1;
        int g = lca(0, a, b);
        ime[a] = 1;
        ime[b] = 1;
        ime[g] = 1;
        int tr = 0;
        while(a != g){
            a = par[0][a][0];
            ime[a] = 1;
        }
        while(b != g){
            b = par[0][b][0];
            ime[b] = 1;
        }
        a = (C1[qr] + lstr*P - 1)%N +1;
        b = (D1[qr] + lstr*P - 1)%N +1;
        g = lca(1, a, b);
        tr += ime[a];
        ime[a] = 0;
        tr += ime[b];
        ime[b] = 0;
        tr += ime[g];
        ime[g] = 0;
        while(a != g){
            a = par[1][a][0];
            tr += ime[a];
            ime[a] = 0;
        }
        while(b != g){
            b = par[1][b][0];
            tr += ime[b];
            ime[b] = 0;
        }
        R[qr] = tr;
        lstr = tr;
    }
    /*for(int i=1; i<=N; i++) cout << in[0][i] << " x ";
    cout << endl;
    for(int i=1; i<=N; i++) a[in[i]] = i;
    return;
    for(int qr=1; qr<=Q; qr++){
        vector <pair <int, int>> ch1;
        vector <pair <int, int>> ch2;
        int a = A1[qr];
        int b = B1[qr];
        int g = lca(0, a, b);
        while(a){
            if(is_parent(0, g, chroot[0][a])){
                ch1.push_back({in[1][a1], in[0][b1]});
                break;
            }
            //ch1.push_back({});
        }
    }*/
}